/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.formatengine.impl;

import jbookreader.formatengine.IAdjustableDrawable;
import jbookreader.rendering.IDrawable;
import jbookreader.rendering.IGraphicDriver;
import jbookreader.rendering.Position;

class Glue
implements IDrawable,
IAdjustableDrawable {
    private final int space;
    private final int stretch;
    private final int shrink;
    private final IGraphicDriver driver;
    private int adjustment;

    Glue(IGraphicDriver driver, int space, int stretch, int shrink) {
        this.driver = driver;
        this.space = space;
        this.stretch = stretch;
        this.shrink = shrink;
    }

    @Override
    public int getShrink(Position position) {
        if (position != Position.MIDDLE) {
            return 0;
        }
        return this.stretch;
    }

    @Override
    public int getWidth(Position position) {
        if (position != Position.MIDDLE) {
            return 0;
        }
        return this.space + this.adjustment;
    }

    @Override
    public int getStretch(Position position) {
        if (position != Position.MIDDLE) {
            return 0;
        }
        return this.stretch;
    }

    @Override
    public int getDepth() {
        return 0;
    }

    @Override
    public int getHeight() {
        return 0;
    }

    @Override
    public void draw(Position position) {
        this.driver.addHorizontalSpace(this.getWidth(position));
    }

    public String toString() {
        return "Glue: " + this.space + "+" + this.adjustment + ":" + this.stretch + ":" + this.shrink;
    }

    @Override
    public void adjust(int adjust) {
        this.adjustment = adjust;
    }
}

