/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.fileformats.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import jbookreader.fileformats.IFileFormatDescriptor;
import jbookreader.fileformats.impl.FictionBook2;
import jbookreader.fileformats.impl.RichTextFormat;
import jbookreader.fileformats.impl.UnknownFormatException;

public class FileFormatsLibrary {
    private static final Collection<IFileFormatDescriptor> fileFormats = new ArrayList<IFileFormatDescriptor>();

    private FileFormatsLibrary() {
    }

    private static void populateFormats() {
        if (fileFormats.size() != 0) {
            return;
        }
        fileFormats.add(new FictionBook2());
        fileFormats.add(new RichTextFormat());
    }

    public static Collection<IFileFormatDescriptor> getFileFormats() {
        FileFormatsLibrary.populateFormats();
        return Collections.unmodifiableCollection(fileFormats);
    }

    public static IFileFormatDescriptor getDescriptorForFile(String file) throws UnknownFormatException {
        FileFormatsLibrary.populateFormats();
        for (IFileFormatDescriptor d : fileFormats) {
            for (String ext : d.getExtensions()) {
                if (!file.endsWith(ext)) continue;
                return d;
            }
        }
        throw new UnknownFormatException();
    }
}

