/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.formatengine.impl;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import org.jbookreader.book.bom.IBinaryData;
import org.jbookreader.book.bom.IContainerNode;
import org.jbookreader.book.bom.IImageNode;
import org.jbookreader.book.bom.INode;
import org.jbookreader.book.stylesheet.IStyleStack;
import org.jbookreader.formatengine.IBookPainter;
import org.jbookreader.formatengine.IFont;
import org.jbookreader.formatengine.IFormatEngine;
import org.jbookreader.formatengine.IInlineRenderingObject;
import org.jbookreader.formatengine.IRenderingObject;
import org.jbookreader.formatengine.objects.HorizontalGlue;
import org.jbookreader.formatengine.objects.Line;
import org.jbookreader.formatengine.objects.MetaString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatEngine
implements IFormatEngine {
    private List<IRenderingObject> myResult;
    private Line myCurrentLine;

    private int consumeWhitespace(String text, int start) {
        while (start < text.length() && text.charAt(start) <= ' ') {
            ++start;
        }
        return start;
    }

    private void formatNode(INode node, IStyleStack styleStack, double width) {
        if (node instanceof IContainerNode) {
            this.formatContainerNode((IContainerNode)node, styleStack, width);
        } else if (node instanceof IImageNode) {
            this.formatInlineImageNode((IImageNode)node, styleStack, width);
        } else {
            this.formatTextNode(node, styleStack, width);
        }
    }

    private void formatContainerNode(IContainerNode cnode, IStyleStack styleStack, double width) {
        for (INode childNode : cnode.getChildNodes()) {
            styleStack.pushTag(childNode.getTagName(), childNode.getNodeClass(), childNode.getID());
            this.formatNode(childNode, styleStack, width);
            styleStack.popTag();
        }
    }

    private IInlineRenderingObject getImageObject(IBookPainter painter, IImageNode image) {
        IBinaryData blob = image.getBook().getBinaryData(image.getHyperRef().substring(1));
        IInlineRenderingObject robject = painter.getImage(null, blob.getContentType(), new ByteArrayInputStream(blob.getContentsArray(), 0, blob.getContentsLength()));
        return robject;
    }

    private void formatInlineImageNode(IImageNode image, IStyleStack styleStack, double width) {
        IInlineRenderingObject robject = this.getImageObject(this.myCurrentLine.getPainter(), image);
        if (robject == null) {
            this.formatTextNode(image, styleStack, width);
        } else {
            this.appendRobject(robject, styleStack, width);
        }
    }

    private void formatImageNode(IBookPainter painter, IImageNode image, IStyleStack styleStack, double width) {
        IInlineRenderingObject robject = this.getImageObject(painter, image);
        if (robject == null) {
            this.newParagraph(painter, image, styleStack);
            this.formatTextNode(image, styleStack, width -= styleStack.getMarginLeft() + styleStack.getMarginRight());
            this.myResult.add(this.myCurrentLine);
            this.myCurrentLine = null;
        } else {
            this.myResult.add(robject);
        }
    }

    private void formatTextNode(INode node, IStyleStack styleStack, double width) {
        String text = node.getText();
        if (text == null) {
            System.err.println("WARNING: node '" + node.getTagName() + "' doesn't has text");
            return;
        }
        IFont font = this.myCurrentLine.getPainter().getFont(styleStack.getFontFamily(), styleStack.getFontSize());
        int start = 0;
        int end = 0;
        while (end < text.length()) {
            double strut;
            int newWord = this.consumeWhitespace(text, start);
            if (newWord > start && (strut = font.getSpaceWidth()) + this.myCurrentLine.getWidth() <= width) {
                this.myCurrentLine.appendObject(new HorizontalGlue(this.myCurrentLine.getPainter(), node, strut));
            }
            if ((end = (start = newWord)) >= text.length()) break;
            while (end < text.length() && text.charAt(end) > ' ') {
                ++end;
            }
            MetaString string = new MetaString(this.myCurrentLine.getPainter(), node, styleStack.getLineHeight(), text, start, end, font);
            this.appendRobject(string, styleStack, width);
            start = end;
        }
    }

    private void flushLine(boolean lastLine, double width, IStyleStack styleStack) {
        switch (styleStack.getTextAlign()) {
            case LEFT: {
                this.myCurrentLine.appendObject(new HorizontalGlue(this.myCurrentLine.getPainter(), this.myCurrentLine.getNode(), width - this.myCurrentLine.getWidth()));
                break;
            }
            case RIGHT: {
                this.myCurrentLine.prependObject(new HorizontalGlue(this.myCurrentLine.getPainter(), this.myCurrentLine.getNode(), width - this.myCurrentLine.getWidth()));
                break;
            }
            case CENTER: {
                this.myCurrentLine.prependObject(new HorizontalGlue(this.myCurrentLine.getPainter(), this.myCurrentLine.getNode(), (width - this.myCurrentLine.getWidth()) / 2.0));
                this.myCurrentLine.appendObject(new HorizontalGlue(this.myCurrentLine.getPainter(), this.myCurrentLine.getNode(), width - this.myCurrentLine.getWidth()));
                break;
            }
            case JUSTIFY: {
                if (lastLine) break;
                this.myCurrentLine.adjustWidth(width - this.myCurrentLine.getWidth());
            }
        }
        this.myResult.add(this.myCurrentLine);
        this.myCurrentLine = null;
    }

    private void appendRobject(IInlineRenderingObject object, IStyleStack styleStack, double width) {
        if (this.myCurrentLine.getWidth() + object.getWidth() > width) {
            Line newLine = new Line(this.myCurrentLine.getPainter(), this.myCurrentLine.getNode());
            this.flushLine(false, width, styleStack);
            this.myCurrentLine = newLine;
        }
        this.myCurrentLine.appendObject(object);
    }

    private void newParagraph(IBookPainter painter, INode node, IStyleStack styleStack) {
        this.myResult = new ArrayList<IRenderingObject>();
        this.myCurrentLine = new Line(painter, node);
        this.myCurrentLine.appendObject(new HorizontalGlue(painter, node, styleStack.getTextIndent()));
    }

    private void formatStyledText(IBookPainter painter, INode node, IStyleStack styleStack, double width) {
        this.newParagraph(painter, node, styleStack);
        this.formatNode(node, styleStack, width -= styleStack.getMarginLeft() + styleStack.getMarginRight());
        if (this.myCurrentLine.getHeight() == 0.0 && this.myCurrentLine.getWidth() == 0.0) {
            this.myCurrentLine.appendObject(new HorizontalGlue(painter, this.myCurrentLine.getNode(), 0.0, styleStack.getLineHeight() * (double)styleStack.getFontSize()));
        }
        this.flushLine(true, width, styleStack);
    }

    @Override
    public List<IRenderingObject> formatParagraphNode(IBookPainter painter, INode node, IStyleStack styleStack, double width) {
        this.myResult = new ArrayList<IRenderingObject>();
        if (node instanceof IImageNode) {
            this.formatImageNode(painter, (IImageNode)node, styleStack, width);
        } else {
            this.formatStyledText(painter, node, styleStack, width);
        }
        this.myResult.get(0).setMarginTop(styleStack.getMarginTop());
        this.myResult.get(this.myResult.size() - 1).setMarginBottom(styleStack.getMarginBottom());
        for (IRenderingObject robject : this.myResult) {
            robject.setMarginLeft(styleStack.getMarginLeft());
            robject.setMarginRight(styleStack.getMarginRight());
        }
        return this.myResult;
    }
}

