/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.book.bom;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import junit.framework.TestCase;
import org.jbookreader.TestConfig;
import org.jbookreader.book.bom.IBook;
import org.jbookreader.book.bom.IContainerNode;
import org.jbookreader.book.bom.INode;
import org.jbookreader.book.bom.impl.Book;
import org.jbookreader.util.ModelDumper;
import org.lumag.filetest.FileTestUtil;
import org.lumag.filetest.ITestConfig;

public class BookModelTest
extends TestCase {
    private IBook myBook;
    private IContainerNode myContainer;

    public void setUp() {
        IContainerNode node;
        this.myBook = new Book();
        this.myContainer = node = this.myBook.newBody("body", null);
        this.myContainer = node = this.myContainer.newTitle("title");
        this.myContainer = node = this.myContainer.newContainerNode("p");
        this.myContainer.newTextNode("Title");
        this.myContainer = this.myContainer.getParentNode();
        this.myContainer = this.myContainer.getParentNode();
        this.myContainer = node = this.myContainer.newContainerNode("section");
        this.myContainer = node = this.myContainer.newTitle("title");
        this.myContainer = node = this.myContainer.newContainerNode("p");
        this.myContainer.newTextNode("Section title.");
        this.myContainer = this.myContainer.getParentNode();
        this.myContainer = this.myContainer.getParentNode();
        this.myContainer = node = this.myContainer.newContainerNode("p");
        this.myContainer.newTextNode("Section text ");
        this.myContainer = node = this.myContainer.newContainerNode("emphasis");
        this.myContainer.newTextNode("in italic");
        this.myContainer = this.myContainer.getParentNode();
        this.myContainer.newTextNode(".");
        this.myContainer = this.myContainer.getParentNode();
        this.myContainer = this.myContainer.getParentNode();
        this.myContainer = this.myContainer.getParentNode();
    }

    public void testSetUp() throws IOException {
        BookModelTest.assertNotNull((Object)this.myBook);
        BookModelTest.assertNull((Object)this.myContainer);
        File expected = FileTestUtil.getExpectedFile((ITestConfig)new TestConfig(), (String)"BOM", (String)"BOM.xml");
        File tempFile = FileTestUtil.getTempFile((ITestConfig)new TestConfig(), (String)"BOM", (String)"BOM.xml");
        PrintWriter pwr = new PrintWriter(new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(tempFile))));
        ModelDumper.dumpBOM(pwr, this.myBook);
        pwr.close();
        FileTestUtil.assertFileEqualsStream((File)expected, (File)tempFile);
        tempFile.delete();
    }

    public void testNewBody() {
        IContainerNode body = this.myBook.getMainBody();
        BookModelTest.assertEquals((String)"body", (String)body.getTagName());
        BookModelTest.assertEquals((Object)this.myBook, (Object)body.getBook());
        BookModelTest.assertNull((Object)body.getParentNode());
    }

    public void testNewTitle() {
        IContainerNode pnode = this.myBook.getMainBody();
        BookModelTest.assertNotNull((Object)pnode.getTitle());
        INode node = null;
        for (INode temp : pnode.getChildNodes()) {
            if (!temp.getTagName().equals("section")) continue;
            node = temp;
            break;
        }
        BookModelTest.assertNotNull((String)"Can't find 'section' node", node);
        IContainerNode cnode = (IContainerNode)node;
        BookModelTest.assertNotNull((Object)cnode);
        BookModelTest.assertNotNull((Object)cnode.getTitle());
        IContainerNode title = cnode.getTitle();
        BookModelTest.assertEquals((String)"title", (String)title.getTagName());
        BookModelTest.assertEquals((Object)this.myBook, (Object)title.getBook());
        BookModelTest.assertEquals((Object)cnode, (Object)title.getParentNode());
        BookModelTest.assertTrue((boolean)cnode.getChildNodes().contains(title));
    }

    public void testNewContainerNode() {
        IContainerNode bnode = this.myBook.getMainBody();
        INode childnode = bnode.getChildNodes().iterator().next();
        IContainerNode pnode = (IContainerNode)childnode;
        BookModelTest.assertNotNull((Object)pnode);
        childnode = pnode.getChildNodes().iterator().next();
        BookModelTest.assertEquals((String)"p", (String)childnode.getTagName());
        BookModelTest.assertNotNull((Object)childnode);
        BookModelTest.assertEquals((Object)this.myBook, (Object)childnode.getBook());
        BookModelTest.assertEquals((Object)pnode, (Object)childnode.getParentNode());
    }

    public void testNewTextNode() {
        IContainerNode bnode = this.myBook.getMainBody();
        INode childnode = bnode.getChildNodes().iterator().next();
        IContainerNode pnode = (IContainerNode)childnode;
        childnode = pnode.getChildNodes().iterator().next();
        IContainerNode cnode = (IContainerNode)childnode;
        INode node = cnode.newTextNode("test text");
        BookModelTest.assertTrue((boolean)cnode.getChildNodes().contains(node));
        BookModelTest.assertEquals((String)"#text", (String)node.getTagName());
        BookModelTest.assertFalse((boolean)(node instanceof IContainerNode));
        BookModelTest.assertEquals((String)"test text", (String)node.getText());
    }
}

