/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.ui.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import org.jbookreader.formatengine.IBookPainter;
import org.jbookreader.formatengine.ITextFont;
import org.jbookreader.formatengine.model.RenderingDimensions;

public class SwingBookPainter
implements IBookPainter {
    private double myWidth;
    private double myHeight;
    private Graphics2D myGraphics;
    private float myCurrentX;
    private float myCurrentY;

    public void setGraphics(Graphics2D g2d, double width, double height) {
        this.myGraphics = g2d;
        this.myWidth = width;
        this.myHeight = height;
        this.myCurrentY = 0.0f;
        this.myCurrentX = 0.0f;
    }

    public void clear() {
        this.myGraphics.setColor(this.myGraphics.getBackground());
        this.myGraphics.fill(this.myGraphics.getClip());
        this.myGraphics.setColor(Color.BLACK);
        this.myGraphics.drawRect(0, 0, (int)this.myWidth - 1, (int)this.myHeight - 1);
        this.myCurrentY = 0.0f;
        this.myCurrentX = 0.0f;
    }

    public double getHeight() {
        return this.myHeight;
    }

    public double getWidth() {
        return this.myWidth;
    }

    public RenderingDimensions calculateStringDimensions(String s, int start, int end, ITextFont ifont) {
        TextFontImpl fontImpl = (TextFontImpl)ifont;
        Font font = fontImpl.getFont();
        FontRenderContext frc = this.myGraphics.getFontRenderContext();
        LineMetrics metrics = font.getLineMetrics(s, start, end, frc);
        Rectangle2D r2d = font.getStringBounds(s, start, end, frc);
        return new RenderingDimensions(metrics.getAscent(), metrics.getDescent(), r2d.getMaxX() - r2d.getMinX());
    }

    public void renderString(String s, int start, int end, ITextFont ifont, RenderingDimensions dimensions) {
        TextFontImpl fontImpl = (TextFontImpl)ifont;
        Font font = fontImpl.getFont();
        if (!this.myGraphics.getFont().equals(font)) {
            this.myGraphics.setFont(font);
        }
        this.myGraphics.setColor(Color.BLACK);
        this.myGraphics.drawString(s.substring(start, end), this.myCurrentX, this.myCurrentY);
        this.myCurrentX = (float)((double)this.myCurrentX + dimensions.width);
    }

    public void addHorizontalStrut(double size) {
        this.myCurrentX = (float)((double)this.myCurrentX + size);
    }

    public void addVerticalStrut(double size) {
        this.myCurrentY = (float)((double)this.myCurrentY + size);
    }

    public void flushString() {
        this.myCurrentX = 0.0f;
    }

    public ITextFont getFont(String name, int size) {
        return new TextFontImpl(name, size);
    }

    public double getYCoordinate() {
        return this.myCurrentY;
    }

    private class TextFontImpl
    implements ITextFont {
        private final Font myFont;
        private double mySpaceWidth = 0.0;

        public TextFontImpl(String name, int size) {
            this.myFont = new Font(name, 0, size);
        }

        public double getSpaceWidth() {
            if (this.mySpaceWidth == 0.0) {
                FontRenderContext frc = SwingBookPainter.this.myGraphics.getFontRenderContext();
                GlyphVector gv = this.myFont.createGlyphVector(frc, new char[]{' '});
                Rectangle2D r2d = gv.getLogicalBounds();
                this.mySpaceWidth = r2d.getMaxX() - r2d.getMinX();
            }
            return this.mySpaceWidth;
        }

        public Font getFont() {
            return this.myFont;
        }
    }
}

