/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.formatengine.model;

import org.jbookreader.formatengine.IBookPainter;
import org.jbookreader.formatengine.ITextFont;
import org.jbookreader.formatengine.model.IRenderingObject;
import org.jbookreader.formatengine.model.RenderingDimensions;

public class MetaString
implements IRenderingObject {
    private final String myText;
    private final int myStart;
    private final int myEnd;
    private final IBookPainter myPainter;
    private final ITextFont myFont;
    private final RenderingDimensions myDimensions;

    public MetaString(String text, int start, int end, IBookPainter painter, ITextFont font) {
        this.myText = text;
        this.myStart = start;
        this.myEnd = end;
        this.myFont = font;
        this.myPainter = painter;
        this.myDimensions = painter.calculateStringDimensions(this.myText, start, end, font);
    }

    public RenderingDimensions getDimensions() {
        return this.myDimensions;
    }

    public void render() {
        this.myPainter.renderString(this.myText, this.myStart, this.myEnd, this.myFont, this.myDimensions);
    }

    public boolean isGlue() {
        return false;
    }
}

