/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.formatengine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jbookreader.book.bom.IBook;
import org.jbookreader.book.bom.IContainerNode;
import org.jbookreader.book.bom.INode;
import org.jbookreader.book.stylesheet.EDisplayType;
import org.jbookreader.book.stylesheet.IStyleSheet;
import org.jbookreader.formatengine.IBookPainter;
import org.jbookreader.formatengine.model.HorizontalGlue;
import org.jbookreader.formatengine.model.IRenderingObject;
import org.jbookreader.formatengine.model.Line;
import org.jbookreader.formatengine.model.MetaString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatEngine {
    private IBookPainter myPainter;
    private IBook myBook;
    private List<Line> myLines = new ArrayList<Line>();
    private int myStartLine;
    private int myNextPageLine = -1;
    private static final double BASE_LINE_SKIP = 12.0;
    private static final double LINE_SKIP_LIMIT = 1.0;
    private static final double LINE_SKIP = 1.0;

    public void setPainter(IBookPainter painter) {
        this.myPainter = painter;
    }

    public void setBook(IBook book) {
        this.myBook = book;
        this.myStartLine = 0;
        this.myLines.clear();
    }

    private int consumeWhitespace(String text, int start) {
        while (start < text.length() && text.charAt(start) <= ' ') {
            ++start;
        }
        return start;
    }

    /*
     * Unable to fully structure code
     */
    private Line formatNode(List<Line> result, Line currentLine, IContainerNode cnode) {
        block0: for (INode node : cnode.getChildNodes()) {
            if (node.isContainer()) {
                currentLine = this.formatNode(result, currentLine, (IContainerNode)node);
                continue;
            }
            text = node.getText();
            start = 0;
            end = 0;
            font = this.myPainter.getFont("default", 10);
            while (end < text.length()) {
                temp = this.consumeWhitespace(text, start);
                if (temp > start) {
                    strut = font.getSpaceWidth();
                    if (currentLine.getLeftMargin() + currentLine.getWidth() + strut + currentLine.getRightMargin() > this.myPainter.getWidth()) {
                        currentLine = this.flushLine(result, currentLine);
                    } else {
                        currentLine.addObject(new HorizontalGlue(strut, this.myPainter));
                    }
                }
                if ((end = (start = temp)) < text.length()) ** GOTO lbl20
                continue block0;
lbl-1000:
                // 1 sources

                {
                    ++end;
lbl20:
                    // 2 sources

                    ** while (end < text.length() && text.charAt((int)end) > ' ')
                }
lbl21:
                // 1 sources

                dim = this.myPainter.calculateStringDimensions(text, start, end, font);
                if (currentLine.getLeftMargin() + currentLine.getWidth() + dim.width + currentLine.getRightMargin() > this.myPainter.getWidth() && !currentLine.getObjects().isEmpty()) {
                    currentLine = this.flushLine(result, currentLine);
                }
                currentLine.addObject(new MetaString(text, start, end, this.myPainter, font));
                start = end;
            }
        }
        return currentLine;
    }

    private Line flushLine(List<Line> result, Line currentLine) {
        result.add(currentLine);
        IContainerNode node = currentLine.getParagraphNode();
        Line line = new Line(false, node);
        line.setLeftMargin(this.myBook.getSystemStyleSheet().getLeftMargin(node));
        line.setRightMargin(this.myBook.getSystemStyleSheet().getRightMargin(node));
        return line;
    }

    private IContainerNode getNextParagraphNode(IContainerNode node) {
        int index;
        List<INode> children;
        while (true) {
            IContainerNode pnode;
            if ((pnode = node.getParentNode()) == null) {
                return null;
            }
            children = pnode.getChildNodes();
            index = children.indexOf(node);
            if (index == -1) {
                throw new IllegalStateException("Node '" + node + "' not found in it's parent list!!!!");
            }
            if (index + 1 < children.size()) break;
            node = pnode;
        }
        node = (IContainerNode)children.get(index + 1);
        return this.getFirstParagraphNodeDown(node);
    }

    private IContainerNode getPreviousParagraphNode(IContainerNode node) {
        int index;
        List<INode> children;
        while (true) {
            IContainerNode pnode;
            if ((pnode = node.getParentNode()) == null) {
                return null;
            }
            children = pnode.getChildNodes();
            index = children.indexOf(node);
            if (index == -1) {
                throw new IllegalStateException("Node '" + node + "' not found in it's parent list!!!!");
            }
            if (index - 1 >= 0) break;
            node = pnode;
        }
        node = (IContainerNode)children.get(index - 1);
        return this.getLastParagraphNodeDown(node);
    }

    private IContainerNode getFirstParagraphNodeDown(IContainerNode node) {
        IStyleSheet ssheet = node.getBook().getSystemStyleSheet();
        while (node.isContainer()) {
            List<INode> children = node.getChildNodes();
            if (children.isEmpty()) {
                return node;
            }
            INode child = children.get(0);
            if (ssheet.getNodeDisplayType(child) == EDisplayType.INLINE) {
                return node;
            }
            if (!child.isContainer()) {
                throw new IllegalStateException("child node isn't INLINE, but isn't a container: " + node.getTagName() + " -> " + child.getTagName());
            }
            node = (IContainerNode)child;
        }
        return node;
    }

    private IContainerNode getLastParagraphNodeDown(IContainerNode node) {
        IStyleSheet ssheet = node.getBook().getSystemStyleSheet();
        while (node.isContainer()) {
            List<INode> children = node.getChildNodes();
            if (children.isEmpty()) {
                return node;
            }
            INode child = children.get(children.size() - 1);
            if (ssheet.getNodeDisplayType(child) == EDisplayType.INLINE) {
                return node;
            }
            if (!child.isContainer()) {
                throw new IllegalStateException("child node isn't INLINE, but isn't a container: " + node.getTagName() + " -> " + child.getTagName());
            }
            node = (IContainerNode)child;
        }
        return node;
    }

    public void renderPage(boolean reformat) {
        IContainerNode savedNode = null;
        this.myPainter.clear();
        if (reformat) {
            if (this.myStartLine < this.myLines.size()) {
                savedNode = this.myLines.get(this.myStartLine).getParagraphNode();
                this.myStartLine = 0;
            }
            this.myLines.clear();
        }
        int lineNum = this.myStartLine;
        double previousDepth = 0.0;
        while (this.myPainter.getYCoordinate() < this.myPainter.getHeight()) {
            Line line;
            if (lineNum >= this.myLines.size()) {
                IContainerNode node;
                if (this.myLines.size() == 0) {
                    node = savedNode == null ? this.getFirstParagraphNodeDown(this.myBook.getMainBody()) : savedNode;
                } else {
                    IContainerNode lastNode = this.myLines.get(this.myLines.size() - 1).getParagraphNode();
                    node = this.getNextParagraphNode(lastNode);
                }
                if (node == null) {
                    if (this.myStartLine >= this.myLines.size()) {
                        lineNum = this.myStartLine = this.myLines.size() - 1;
                        continue;
                    }
                    this.myNextPageLine = this.myStartLine;
                    return;
                }
                Line cur = new Line(true, node);
                cur.setLeftMargin(this.myBook.getSystemStyleSheet().getFirstLineMargin(node));
                cur.setRightMargin(this.myBook.getSystemStyleSheet().getRightMargin(node));
                cur = this.formatNode(this.myLines, cur, node);
                this.myLines.add(cur);
            }
            if (previousDepth + 1.0 + (line = this.myLines.get(lineNum)).getHeight() < 12.0) {
                this.myPainter.addVerticalStrut(12.0);
            } else {
                this.myPainter.addVerticalStrut(previousDepth + 1.0 + line.getHeight());
            }
            this.myPainter.addHorizontalStrut(line.getLeftMargin());
            Iterator<IRenderingObject> it = line.getObjects().iterator();
            while (it.hasNext()) {
                IRenderingObject ro = it.next();
                if (ro.isGlue() && !it.hasNext()) break;
                ro.render();
            }
            this.myPainter.flushString();
            previousDepth = line.getDepth();
            ++lineNum;
        }
        this.myNextPageLine = lineNum - 1;
    }

    private void cleanStartLines() {
        int line = this.myStartLine;
        while (!this.myLines.get(line).isFirstLine()) {
            --line;
        }
        int i = 0;
        while (i < line) {
            this.myLines.remove(0);
            ++i;
        }
        this.myStartLine -= line;
    }

    public void scrollPageDown() {
        if (this.myNextPageLine < 0) {
            return;
        }
        this.myStartLine = this.myNextPageLine;
        this.cleanStartLines();
    }

    public void scrollDown(int lines) {
        this.myStartLine += lines;
        this.myNextPageLine = -1;
        if (this.myStartLine >= this.myLines.size()) {
            return;
        }
        if (this.myLines.get(this.myStartLine).isFirstLine()) {
            this.cleanStartLines();
        }
    }

    public void scrollUp(int lines) {
        this.myStartLine -= lines;
        this.myNextPageLine = -1;
        while (this.myStartLine < 0) {
            IContainerNode node = this.getPreviousParagraphNode(this.myLines.get(0).getParagraphNode());
            if (node == null) {
                this.myStartLine = 0;
                return;
            }
            ArrayList<Line> curParagraph = new ArrayList<Line>();
            Line cur = new Line(true, node);
            cur.setLeftMargin(this.myBook.getSystemStyleSheet().getFirstLineMargin(node));
            cur.setRightMargin(this.myBook.getSystemStyleSheet().getRightMargin(node));
            cur = this.formatNode(curParagraph, cur, node);
            curParagraph.add(cur);
            this.myLines.addAll(0, curParagraph);
            this.myStartLine += curParagraph.size();
        }
    }
}

