/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.book.stylesheet.impl;

import java.util.HashMap;
import java.util.Map;
import org.jbookreader.book.bom.INode;
import org.jbookreader.book.stylesheet.EDisplayType;
import org.jbookreader.book.stylesheet.IStyleSheet;

public class FB2StyleSheet
implements IStyleSheet {
    private Map<String, EDisplayType> myDisplayTypes = new HashMap<String, EDisplayType>();
    private static final String[] FB2_BLOCK_TAGS = new String[]{"body", "section", "title", "p", "empty-line", "abstract", "epigraph"};
    private static final String[] FB2_INLINE_TAGS = new String[]{"strong", "emphasis", "strikethrough", "sub", "sup", "code", "a", "#text"};

    public FB2StyleSheet() {
        String s;
        String[] stringArray = FB2_INLINE_TAGS;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            s = stringArray[n];
            this.myDisplayTypes.put(s, EDisplayType.INLINE);
            ++n;
        }
        stringArray = FB2_BLOCK_TAGS;
        n = 0;
        n2 = stringArray.length;
        while (n < n2) {
            s = stringArray[n];
            this.myDisplayTypes.put(s, EDisplayType.BLOCK);
            ++n;
        }
    }

    public EDisplayType getNodeDisplayType(INode node) {
        if (this.myDisplayTypes.containsKey(node.getTagName())) {
            return this.myDisplayTypes.get(node.getTagName());
        }
        System.err.println("Got unknown tag: '" + node.getTagName() + "'! Check your parser version, please");
        return EDisplayType.BLOCK;
    }

    public double getLeftMargin(INode node) {
        return 5.0;
    }

    public double getFirstLineMargin(INode node) {
        return 10.0;
    }

    public double getRightMargin(INode node) {
        return 5.0;
    }
}

