/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.book.parser;

import java.io.File;
import java.io.IOException;
import org.jbookreader.book.bom.IBinaryData;
import org.jbookreader.book.bom.IBook;
import org.jbookreader.book.bom.IContainerNode;
import org.jbookreader.book.bom.ISectioningNode;
import org.jbookreader.book.bom.impl.Book;
import org.jbookreader.book.parser.ParseErrorHandler;
import org.jbookreader.book.stylesheet.IStyleSheet;
import org.jbookreader.book.stylesheet.impl.FB2StyleSheet;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class FB2Parser {
    public static final String FB2_XMLNS_URI = "http://www.gribuser.ru/xml/fictionbook/2.0";
    private static IStyleSheet ssheet;

    public static IBook parse(String uri) throws IOException, SAXException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setErrorHandler(new ParseErrorHandler());
        Book book = new Book();
        book.setSystemStyleSheet(FB2Parser.getFB2StyleSheet());
        reader.setContentHandler(new FB2ContentsHandler(book));
        reader.parse(new InputSource(uri));
        return book;
    }

    public static IBook parse(File file) throws IOException, SAXException {
        return FB2Parser.parse(file.getAbsolutePath());
    }

    private static IStyleSheet getFB2StyleSheet() {
        if (ssheet == null) {
            ssheet = new FB2StyleSheet();
        }
        return ssheet;
    }

    private static class FB2ContentsHandler
    extends DefaultHandler {
        private Locator myLocator;
        private final IBook myBook;
        private IBinaryData myBinaryData;
        private ISectioningNode mySection;
        private IContainerNode myContainer;
        private StringBuilder myText = new StringBuilder();
        private boolean hadOpenTag = false;
        private boolean parseXML = false;
        private boolean myParseText = false;

        public FB2ContentsHandler(IBook book) {
            this.myBook = book;
        }

        public void setDocumentLocator(Locator locator) {
            this.myLocator = locator;
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void characters(char[] ch, int start, int length) {
            if (!this.parseXML) {
                return;
            }
            if (!this.myParseText) {
                return;
            }
            this.myText.append(ch, start, length);
        }

        private void processTextNode(boolean hasCloseTag) {
            String string = FB2ContentsHandler.trimStringBuilder(this.myText, this.hadOpenTag, hasCloseTag);
            this.myText.setLength(0);
            if (string.length() == 0) {
                return;
            }
            this.myContainer.newTextNode(string);
        }

        private boolean isParagraphTag(String tagName) {
            return tagName.equals("p") || tagName.equals("subtitle") || tagName.equals("text-author") || tagName.equals("v");
        }

        public void endElement(String uri, String localName, String qName) {
            if (!this.parseXML) {
                return;
            }
            if (!localName.equals("FictionBook")) {
                if (localName.equals("binary")) {
                    this.myBinaryData.setBase64Encoded(this.myText.toString().toCharArray());
                    this.myBinaryData = null;
                } else {
                    this.processTextNode(true);
                    this.hadOpenTag = false;
                    if (this.isParagraphTag(localName)) {
                        this.myParseText = false;
                    }
                    if (this.myContainer.isSectioningNode()) {
                        this.mySection = this.mySection.getParentSection();
                    }
                    this.myContainer = this.myContainer.getParentNode();
                }
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (!this.parseXML) {
                if (!localName.equals("body")) {
                    return;
                }
                this.parseXML = true;
            }
            this.processTextNode(false);
            this.hadOpenTag = true;
            if (!localName.equals("FictionBook")) {
                IContainerNode node;
                if (localName.equals("binary")) {
                    this.myBinaryData = this.myBook.newBinaryData(attributes.getValue("id"), attributes.getValue("content-type"));
                    return;
                }
                if (localName.equals("body")) {
                    this.mySection = this.myBook.newBody("body", attributes.getValue("name"));
                    node = this.mySection;
                } else if (localName.equals("section")) {
                    this.mySection = this.mySection.newSectioningNode(localName);
                    node = this.mySection;
                } else if (localName.equals("title")) {
                    node = this.mySection.newTitle(localName);
                } else if (this.isParagraphTag(localName)) {
                    node = this.myContainer.newContainerNode(localName);
                    this.myParseText = true;
                } else {
                    node = this.myContainer.newContainerNode(localName);
                }
                this.myContainer = node;
                String id = attributes.getValue("id");
                if (id != null) {
                    node.setID(id);
                }
            }
        }

        private static String trimStringBuilder(StringBuilder builder, boolean trimStart, boolean trimEnd) {
            int length = builder.length();
            if (length == 0 || builder.charAt(0) > ' ' && builder.charAt(length - 1) > ' ') {
                return builder.toString();
            }
            int begin = 0;
            int end = length - 1;
            if (trimStart) {
                while (begin <= end && builder.charAt(begin) <= ' ') {
                    ++begin;
                }
            }
            if (trimEnd) {
                while (begin <= end && builder.charAt(end) <= ' ') {
                    --end;
                }
            }
            if (begin > end) {
                return "";
            }
            return builder.substring(begin, end + 1);
        }
    }
}

