/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.book.bom.impl;

import org.jbookreader.book.bom.IBinaryData;

class BinaryData
implements IBinaryData {
    private String myContentType;
    private byte[] myContentsArray = new byte[1];
    private int myContentsLength;

    BinaryData() {
    }

    public String getContentType() {
        return this.myContentType;
    }

    public void setContentType(String contentType) {
        this.myContentType = contentType;
    }

    public void setBase64Encoded(char[] base64Encoded) {
        this.myContentsArray = new byte[base64Encoded.length / 4 * 3];
        this.myContentsLength = 0;
        long bitBuffer = 0L;
        int bitBufferBytes = 0;
        int byteBufferPad = 0;
        int i = 0;
        while (i < base64Encoded.length) {
            char curch = base64Encoded[i];
            if (curch != '\n' && curch != '\r') {
                bitBuffer <<= 6;
                if (curch >= 'A' && curch <= 'Z') {
                    bitBuffer += (long)(curch - 65);
                } else if (curch >= 'a' && curch <= 'z') {
                    bitBuffer += (long)(curch - 97 + 26);
                } else if (curch >= '0' && curch <= '9') {
                    bitBuffer += (long)(curch - 48 + 52);
                } else if (curch == '+') {
                    bitBuffer += 62L;
                } else if (curch == '/') {
                    bitBuffer += 63L;
                } else if (curch == '=') {
                    ++byteBufferPad;
                } else {
                    throw new IllegalArgumentException("Bad character value: '" + curch + "'");
                }
                if (++bitBufferBytes == 4) {
                    this.myContentsArray[this.myContentsLength++] = (byte)(bitBuffer >> 16);
                    if (byteBufferPad < 2) {
                        this.myContentsArray[this.myContentsLength++] = (byte)(bitBuffer >> 8);
                    }
                    if (byteBufferPad < 1) {
                        this.myContentsArray[this.myContentsLength++] = (byte)(bitBuffer >> 0);
                    }
                    bitBufferBytes = 0;
                    bitBuffer = 0L;
                }
            }
            ++i;
        }
    }

    public void setContents(byte[] contents, int length) {
        if (this.myContentsLength < length) {
            this.myContentsArray = new byte[length];
        }
        this.myContentsLength = length;
        int i = 0;
        while (i < length) {
            this.myContentsArray[i] = contents[i];
            ++i;
        }
    }

    public byte[] getContentsArray() {
        return this.myContentsArray;
    }

    public int getContentsLength() {
        return this.myContentsLength;
    }
}

