/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.formatengine.objects;

import java.util.LinkedList;
import java.util.List;
import org.jbookreader.book.bom.INode;
import org.jbookreader.formatengine.IBookPainter;
import org.jbookreader.formatengine.IInlineRenderingObject;
import org.jbookreader.formatengine.objects.AbstractInlineRenderingObject;

public class Line
extends AbstractInlineRenderingObject {
    private final List<IInlineRenderingObject> myRObjects = new LinkedList<IInlineRenderingObject>();
    private int myAdjustability;

    public Line(IBookPainter painter, INode node) {
        super(painter, node);
    }

    public void appendObject(IInlineRenderingObject object) {
        this.myRObjects.add(object);
        this.adjustProperties(object);
    }

    public void prependObject(IInlineRenderingObject object) {
        this.myRObjects.add(0, object);
        this.adjustProperties(object);
    }

    private void adjustProperties(IInlineRenderingObject object) {
        double oldOver = this.getHeight() - this.getDepth();
        double newOver = object.getHeight() - object.getDepth();
        double oDepth = object.getDepth();
        if (oDepth > this.getDepth()) {
            this.setDepth(oDepth);
        }
        if (newOver > oldOver) {
            this.setHeight(newOver + this.getDepth());
        }
        this.setWidth(this.getWidth() + object.getWidth());
        this.myAdjustability += object.getAdjustability();
    }

    public void renderInline() {
        for (IInlineRenderingObject robject : this.myRObjects) {
            robject.renderInline();
        }
    }

    public int getAdjustability() {
        return this.myAdjustability;
    }

    public void adjustWidth(double width) throws UnsupportedOperationException {
        int adjustability = this.myAdjustability;
        if (adjustability == 0) {
            return;
        }
        this.setWidth(this.getWidth() + width);
        for (IInlineRenderingObject robject : this.myRObjects) {
            if (adjustability == 0) break;
            int currentAdjustability = robject.getAdjustability();
            if (currentAdjustability == 0) continue;
            double adjWidth = width * (double)currentAdjustability / (double)adjustability;
            adjustability -= currentAdjustability;
            robject.adjustWidth(adjWidth);
            width -= adjWidth;
        }
    }
}

