/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.formatengine.objects;

import org.jbookreader.book.bom.INode;
import org.jbookreader.formatengine.IBookPainter;
import org.jbookreader.formatengine.IRenderingObject;

public abstract class AbstractRenderingObject
implements IRenderingObject {
    private double myHeight;
    private double myWidth;
    private double[] myMargins = new double[4];
    private INode myNode;
    private IBookPainter myPainter;

    protected AbstractRenderingObject(IBookPainter painter, INode node) {
        this.myPainter = painter;
        this.myNode = node;
    }

    public double getHeight() {
        return this.myHeight;
    }

    public double getWidth() {
        return this.myWidth;
    }

    protected void setHeight(double height) {
        this.myHeight = height;
    }

    protected void setWidth(double width) {
        this.myWidth = width;
    }

    public INode getNode() {
        return this.myNode;
    }

    public IBookPainter getPainter() {
        return this.myPainter;
    }

    public final void render() {
        this.getPainter().addHorizontalStrut(this.myMargins[3]);
        this.renderContents();
        this.getPainter().addHorizontalStrut(-this.myMargins[3]);
    }

    public abstract void renderContents();

    public void setMarginBottom(double margin) {
        this.myMargins[2] = margin;
    }

    public void setMarginLeft(double margin) {
        this.myMargins[3] = margin;
    }

    public void setMarginRight(double margin) {
        this.myMargins[1] = margin;
    }

    public void setMarginTop(double margin) {
        this.myMargins[0] = margin;
    }

    public boolean isSplittable() {
        return false;
    }

    static interface BoxSides {
        public static final int TOP = 0;
        public static final int RIGHT = 1;
        public static final int BOTTOM = 2;
        public static final int LEFT = 3;
    }
}

