/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.rendering.swing;

import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import jbookreader.rendering.IDrawable;
import jbookreader.rendering.Position;
import jbookreader.rendering.swing.JGraphicDriver;

public class AWTImageAdapter
implements IDrawable {
    private final JGraphicDriver driver;
    private final BufferedImage image;
    private int width;

    public AWTImageAdapter(JGraphicDriver driver, BufferedImage image) {
        this.driver = driver;
        this.image = image;
        this.width = JGraphicDriver.pixelToDimension(image.getWidth());
    }

    @Override
    public void draw(Position position) {
        this.driver.getPaperGraphics().drawImage(this.image, AffineTransform.getTranslateInstance(JGraphicDriver.dimensionToPixel(this.driver.getHorizontalPosition()), JGraphicDriver.dimensionToPixel(this.driver.getVerticalPosition())), this.driver);
        this.driver.horizontalPosition += this.width;
    }

    @Override
    public int getDepth() {
        return 0;
    }

    @Override
    public int getHeight() {
        return JGraphicDriver.pixelToDimension(this.image.getHeight());
    }

    @Override
    public int getWidth(Position position) {
        return this.width;
    }
}

