/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.fileformats.impl;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import jbookreader.book.IBook;
import jbookreader.book.IBookFactory;
import jbookreader.book.IContainerNode;
import jbookreader.book.ITextNode;
import jbookreader.fileformats.IErrorHandler;
import jbookreader.fileformats.IFileFormatDescriptor;
import lumag.rtf.IRTFContentHandler;
import lumag.rtf.RTFParser;
import org.xml.sax.SAXException;

class RichTextFormat
implements IFileFormatDescriptor {
    private final Collection<String> extensions = new ArrayList<String>();

    public RichTextFormat() {
        this.extensions.add(".rtf");
    }

    @Override
    public IBook parse(String uri, IErrorHandler handler, IBookFactory factory) throws SAXException, IOException {
        int len;
        RTFParser parser = new RTFParser();
        RTFHandler rtfHandler = new RTFHandler(factory, parser);
        parser.setHandler(rtfHandler);
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(uri));
        byte[] buffer = new byte[1024];
        while ((len = ((InputStream)stream).read(buffer)) >= 0) {
            parser.process(buffer, 0, len);
        }
        ((InputStream)stream).close();
        return rtfHandler.getBook();
    }

    @Override
    public String getDescription() {
        return "Rich Text Format";
    }

    @Override
    public Collection<String> getExtensions() {
        return this.extensions;
    }

    private class RTFHandler
    implements IRTFContentHandler {
        private final IBookFactory factory;
        private IBook book;
        private IContainerNode container;
        private final RTFParser parser;
        private int unicodeCharLength = 1;
        private int skipChars;
        private int ignoredLevel = Integer.MAX_VALUE;

        public RTFHandler(IBookFactory factory, RTFParser parser) {
            this.factory = factory;
            this.parser = parser;
            this.book = factory.newBook();
            IContainerNode body = factory.newContainerNode();
            this.book.addBody(body, "");
            this.container = factory.newContainerNode();
            body.add(this.container);
        }

        @Override
        public boolean control(String string, boolean hasParameter, int parameter) {
            if (this.parser.getLevel() >= this.ignoredLevel) {
                return true;
            }
            if (string.equals("rtf")) {
                System.out.println("RTF version " + parameter);
            } else if (string.equals("ansicpg")) {
                this.parser.setCharacterSet(parameter);
            } else if (string.equals("par") || string.equals("\n") || string.equals("\r")) {
                IContainerNode node = this.factory.newContainerNode();
                this.container.getParentNode().add(node);
                this.container = node;
            } else if (string.equals("uc")) {
                this.unicodeCharLength = parameter;
            } else if (string.equals("u")) {
                this.string(Character.valueOf((char)parameter).toString());
                this.skipChars = this.unicodeCharLength;
            } else if (string.equals("~") || string.equals(" ")) {
                this.string("\u00a0");
            } else if (string.equals("_")) {
                this.string("\u2011");
            } else if (string.equals("fonttbl") || string.equals("stylesheet") || string.equals("pict")) {
                this.ignoredLevel = this.parser.getLevel();
            } else {
                return false;
            }
            return true;
        }

        @Override
        public void endGroup() {
            if (this.parser.getLevel() < this.ignoredLevel) {
                this.ignoredLevel = Integer.MAX_VALUE;
            }
        }

        @Override
        public void startGroup() {
        }

        @Override
        public void string(String string) {
            if (this.parser.getLevel() >= this.ignoredLevel) {
                return;
            }
            if (this.skipChars >= string.length()) {
                this.skipChars -= string.length();
            } else {
                ITextNode node = this.factory.newTextNode();
                node.setText(string.substring(this.skipChars));
                this.container.add(node);
                this.skipChars = 0;
            }
        }

        public IBook getBook() {
            return this.book;
        }

        @Override
        public void binaryBlob(byte[] bs) {
            --this.skipChars;
        }
    }
}

