/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.ui.swing.painter;

import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.jbookreader.formatengine.IRenderingObject;
import org.jbookreader.formatengine.RenderingDimensions;
import org.jbookreader.ui.swing.painter.SwingBookPainter;

class ImageRenderingObject
implements IRenderingObject {
    private final SwingBookPainter myPainter;
    private final BufferedImage myImage;
    private final RenderingDimensions myDimensions;

    public ImageRenderingObject(SwingBookPainter painter, InputStream stream) throws IOException {
        this.myPainter = painter;
        this.myImage = ImageIO.read(stream);
        if (this.myImage == null) {
            throw new RuntimeException("Can't load image");
        }
        this.myDimensions = new RenderingDimensions(this.myImage.getHeight(), 0.0, this.myImage.getWidth());
    }

    public RenderingDimensions getDimensions() {
        return this.myDimensions;
    }

    public boolean isGlue() {
        return false;
    }

    public void render() {
        this.myPainter.getGraphics().drawImage(this.myImage, new AffineTransform(1.0, 0.0, 0.0, 1.0, this.myPainter.getXCoordinate(), this.myPainter.getYCoordinate() - this.myDimensions.height), null);
    }
}

