/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.ZipInputStream;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import org.jbookreader.book.bom.IBook;
import org.jbookreader.book.parser.FB2Parser;
import org.jbookreader.ui.swing.Config;
import org.jbookreader.ui.swing.JBookComponent;
import org.jbookreader.ui.swing.Messages;
import org.jbookreader.ui.swing.actions.OpenAction;
import org.jbookreader.ui.swing.actions.PageDownAction;
import org.jbookreader.ui.swing.actions.PageUpAction;
import org.jbookreader.ui.swing.actions.QuitAction;
import org.jbookreader.ui.swing.actions.ScrollDownAction;
import org.jbookreader.ui.swing.actions.ScrollUpAction;
import org.xml.sax.SAXException;

public class MainWindow {
    private JBookComponent myBookComponent;
    private JFrame myFrame = new JFrame();
    private static MainWindow ourWindow;

    private JComponent createContents() {
        JPanel pane = new JPanel(new BorderLayout());
        this.myBookComponent = new JBookComponent();
        this.myBookComponent.setOpaque(true);
        pane.add((Component)this.myBookComponent, "Center");
        return pane;
    }

    private JMenuBar createMenuBar() {
        JMenuBar mainmenu = new JMenuBar();
        mainmenu.add(this.createFileMenu());
        mainmenu.add(this.createEditMenu());
        mainmenu.add(this.createViewMenu());
        mainmenu.add(this.createBookmarksMenu());
        mainmenu.add(this.createHelpMenu());
        return mainmenu;
    }

    private JMenu createFileMenu() {
        JMenu menu = new JMenu(Messages.getString("File"));
        menu.setMnemonic(70);
        JMenuItem menuItem = new JMenuItem(OpenAction.getAction());
        menuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        menu.add(menuItem);
        menu.add(new JSeparator());
        menuItem = new JMenuItem(QuitAction.getAction());
        menuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        menu.add(menuItem);
        return menu;
    }

    private JMenu createEditMenu() {
        JMenu menu = new JMenu(Messages.getString("Edit"));
        menu.setMnemonic(69);
        JMenuItem menuItem = new JMenuItem(Messages.getString("Find"), 70);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        menu.add(menuItem);
        menuItem = new JMenuItem(Messages.getString("FindNext"), 88);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        menu.add(menuItem);
        menuItem = new JMenuItem(Messages.getString("FindPrevious"), 86);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(71, 3));
        menu.add(menuItem);
        menu.add(new JSeparator());
        menuItem = new JMenuItem(Messages.getString("Preferences"), 69);
        menu.add(menuItem);
        return menu;
    }

    private JMenu createViewMenu() {
        JMenu menu = new JMenu(Messages.getString("View"));
        menu.setMnemonic(86);
        return menu;
    }

    private JMenu createBookmarksMenu() {
        JMenu menu = new JMenu(Messages.getString("Bookmarks"));
        menu.setMnemonic(66);
        JMenuItem menuItem = new JMenuItem(Messages.getString("AddBookmark"), 65);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        menu.add(menuItem);
        menuItem = new JMenuItem(Messages.getString("EditBookmarks"), 69);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        menu.add(menuItem);
        menu.add(new JSeparator());
        return menu;
    }

    private JMenu createHelpMenu() {
        JMenu menu = new JMenu(Messages.getString("Help"));
        menu.setMnemonic(72);
        JMenuItem menuItem = new JMenuItem(Messages.getString("About"), 65);
        menu.add(menuItem);
        return menu;
    }

    public MainWindow() {
        this.myFrame.addComponentListener(new MainWindowComponentListener());
        this.myFrame.setTitle("JBookReader");
        this.myFrame.setDefaultCloseOperation(3);
        this.myFrame.setJMenuBar(this.createMenuBar());
        Container contentPane = this.myFrame.getContentPane();
        JComponent component = this.createContents();
        component.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
        contentPane.add((Component)component, "Center");
        this.myFrame.addMouseWheelListener(new MainWindowMouseWheelListener());
        this.myFrame.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(34, 0), PageDownAction.getAction().getValue("Name"));
        this.myFrame.getRootPane().getActionMap().put(PageDownAction.getAction().getValue("Name"), PageDownAction.getAction());
        this.myFrame.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(33, 0), PageUpAction.getAction().getValue("Name"));
        this.myFrame.getRootPane().getActionMap().put(PageUpAction.getAction().getValue("Name"), PageUpAction.getAction());
        this.myFrame.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(40, 0), ScrollDownAction.getAction().getValue("Name"));
        this.myFrame.getRootPane().getActionMap().put(ScrollDownAction.getAction().getValue("Name"), ScrollDownAction.getAction());
        this.myFrame.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(38, 0), ScrollUpAction.getAction().getValue("Name"));
        this.myFrame.getRootPane().getActionMap().put(ScrollUpAction.getAction().getValue("Name"), ScrollUpAction.getAction());
        this.myFrame.setLocation(Config.getConfig().getIntValue("main_x"), Config.getConfig().getIntValue("main_y"));
        Dimension dim = new Dimension(Config.getConfig().getIntValue("main_width"), Config.getConfig().getIntValue("main_height"));
        this.myFrame.setPreferredSize(dim);
        this.myFrame.pack();
    }

    public static MainWindow getMainWindow() {
        if (ourWindow == null) {
            ourWindow = new MainWindow();
        }
        return ourWindow;
    }

    public void openBook(File file) {
        try {
            IBook book;
            if (file.getName().endsWith(".zip")) {
                ZipInputStream stream = new ZipInputStream(new FileInputStream(file));
                stream.getNextEntry();
                book = FB2Parser.parse(stream);
            } else {
                book = FB2Parser.parse(file);
            }
            this.myBookComponent.setBook(book);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public JFrame getFrame() {
        return this.myFrame;
    }

    public void dispose() {
        this.myFrame.dispose();
    }

    public JBookComponent getBookComponent() {
        return this.myBookComponent;
    }

    private static class MainWindowMouseWheelListener
    implements MouseWheelListener {
        private MainWindowMouseWheelListener() {
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.getScrollType() == 1) {
                System.out.println("block scroll " + e.getWheelRotation());
                if (e.getWheelRotation() > 0) {
                    PageUpAction.getAction().actionPerformed(null);
                } else {
                    PageDownAction.getAction().actionPerformed(null);
                }
            } else {
                int units;
                System.out.println("unit scroll " + units);
                if (units > 0) {
                    for (units = e.getUnitsToScroll(); units > 0; --units) {
                        ScrollDownAction.getAction().actionPerformed(null);
                    }
                } else {
                    while (units < 0) {
                        ScrollUpAction.getAction().actionPerformed(null);
                        ++units;
                    }
                }
            }
        }
    }

    private static class MainWindowComponentListener
    extends ComponentAdapter {
        private MainWindowComponentListener() {
        }

        public void componentMoved(ComponentEvent e) {
            Point point = MainWindow.getMainWindow().getFrame().getLocation();
            Config.getConfig().setIntValue("main_x", point.x);
            Config.getConfig().setIntValue("main_y", point.y);
        }

        public void componentResized(ComponentEvent e) {
            Dimension dim = MainWindow.getMainWindow().getFrame().getSize();
            Config.getConfig().setIntValue("main_width", dim.width);
            Config.getConfig().setIntValue("main_height", dim.height);
        }
    }
}

