/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.ui.swing;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Configuration {
    private final Properties myProperties;

    public Configuration(String programName, String configuration) {
        this(programName, configuration, null);
    }

    public Configuration(String programName, String configuration, String defaultResource) {
        File configFile;
        Properties defaults = new Properties();
        if (defaultResource != null) {
            InputStream defaultsStream = this.getClass().getClassLoader().getResourceAsStream(defaultResource);
            if (defaultsStream == null) {
                System.err.println("Can't find default properties resource");
            } else {
                try {
                    defaults.load(defaultsStream);
                }
                catch (IOException e) {
                    System.err.println("Can't load default properties");
                    e.printStackTrace(System.err);
                }
                catch (IllegalArgumentException e) {
                    System.err.println("Can't load default properties");
                    e.printStackTrace(System.err);
                }
            }
        }
        this.myProperties = new Properties(defaults);
        File homeDir = new File(System.getProperty("user.home"));
        File programDir = new File(homeDir, '.' + programName);
        if (programDir.exists()) {
            programDir.mkdir();
        }
        if ((configFile = new File(programDir, configuration + ".properties")).exists()) {
            try {
                FileInputStream configStream = new FileInputStream(configFile);
                this.myProperties.load(configStream);
            }
            catch (IOException e) {
                System.err.println("Can't load user properties");
                e.printStackTrace(System.err);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Can't load user properties");
                e.printStackTrace(System.err);
            }
        }
        this.myProperties.list(System.out);
    }
}

