/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.formatengine;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jbookreader.book.bom.IBinaryData;
import org.jbookreader.book.bom.IBook;
import org.jbookreader.book.bom.IContainerNode;
import org.jbookreader.book.bom.IImageNode;
import org.jbookreader.book.bom.INode;
import org.jbookreader.book.stylesheet.EDisplayType;
import org.jbookreader.book.stylesheet.IStyleSheet;
import org.jbookreader.formatengine.IBookPainter;
import org.jbookreader.formatengine.IFont;
import org.jbookreader.formatengine.IRenderingObject;
import org.jbookreader.formatengine.RenderingDimensions;
import org.jbookreader.formatengine.model.HorizontalGlue;
import org.jbookreader.formatengine.model.Line;
import org.jbookreader.formatengine.model.MetaString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatEngine {
    private IBookPainter myPainter;
    private IBook myBook;
    private List<Line> myLines = new ArrayList<Line>();
    private int myStartLine;
    private int myNextPageLine = -1;
    private static final double BASE_LINE_SKIP = 12.0;
    private static final double LINE_SKIP_LIMIT = 1.0;
    private static final double LINE_SKIP = 1.0;

    public void setPainter(IBookPainter painter) {
        this.myPainter = painter;
    }

    public void setBook(IBook book) {
        this.myBook = book;
        this.myStartLine = 0;
        this.myLines.clear();
    }

    private int consumeWhitespace(String text, int start) {
        while (start < text.length() && text.charAt(start) <= ' ') {
            ++start;
        }
        return start;
    }

    private Line formatNode(List<Line> result, Line currentLine, INode node) {
        IImageNode image;
        IBinaryData blob;
        IRenderingObject robject;
        if (node.isContainer()) {
            IContainerNode cnode = (IContainerNode)node;
            for (INode childNode : cnode.getChildNodes()) {
                currentLine = this.formatNode(result, currentLine, childNode);
            }
            return currentLine;
        }
        if (node instanceof IImageNode && (robject = this.myPainter.getImage((blob = this.myBook.getBinaryData((image = (IImageNode)node).getHyperRef().substring(1))).getContentType(), new ByteArrayInputStream(blob.getContentsArray(), 0, blob.getContentsLength()))) != null) {
            RenderingDimensions dim = robject.getDimensions();
            if (currentLine.getLeftMargin() + currentLine.getWidth() + dim.width + currentLine.getRightMargin() > this.myPainter.getWidth() && !currentLine.getObjects().isEmpty()) {
                currentLine = this.flushLine(result, currentLine);
            }
            currentLine.addObject(robject);
            return currentLine;
        }
        String text = node.getText();
        if (text == null) {
            System.err.println("WARNING: node " + node.getTagName() + " doesn't has text");
            return currentLine;
        }
        int start = 0;
        int end = 0;
        IFont font = this.myPainter.getFont("default", 10);
        while (end < text.length()) {
            int temp = this.consumeWhitespace(text, start);
            if (temp > start) {
                double strut = font.getSpaceWidth();
                if (currentLine.getLeftMargin() + currentLine.getWidth() + strut + currentLine.getRightMargin() > this.myPainter.getWidth()) {
                    currentLine = this.flushLine(result, currentLine);
                } else {
                    currentLine.addObject(new HorizontalGlue(strut, this.myPainter));
                }
            }
            if ((end = (start = temp)) >= text.length()) break;
            while (end < text.length() && text.charAt(end) > ' ') {
                ++end;
            }
            RenderingDimensions dim = font.calculateStringDimensions(text, start, end);
            if (currentLine.getLeftMargin() + currentLine.getWidth() + dim.width + currentLine.getRightMargin() > this.myPainter.getWidth() && !currentLine.getObjects().isEmpty()) {
                currentLine = this.flushLine(result, currentLine);
            }
            currentLine.addObject(new MetaString(text, start, end, font));
            start = end;
        }
        return currentLine;
    }

    private Line flushLine(List<Line> result, Line currentLine) {
        result.add(currentLine);
        INode node = currentLine.getParagraphNode();
        Line line = new Line(false, node);
        line.setLeftMargin(this.myBook.getSystemStyleSheet().getLeftMargin(node));
        line.setRightMargin(this.myBook.getSystemStyleSheet().getRightMargin(node));
        return line;
    }

    private INode getNextParagraphNode(INode node) {
        int index;
        List<INode> children;
        while (true) {
            IContainerNode pnode;
            if ((pnode = node.getParentNode()) == null) {
                return null;
            }
            children = pnode.getChildNodes();
            index = children.indexOf(node);
            if (index == -1) {
                throw new IllegalStateException("Node '" + node + "' not found in it's parent list!!!!");
            }
            if (index + 1 < children.size()) break;
            node = pnode;
        }
        node = children.get(index + 1);
        return this.getFirstParagraphNodeDown(node);
    }

    private INode getPreviousParagraphNode(INode node) {
        int index;
        List<INode> children;
        while (true) {
            IContainerNode pnode;
            if ((pnode = node.getParentNode()) == null) {
                return null;
            }
            children = pnode.getChildNodes();
            index = children.indexOf(node);
            if (index == -1) {
                throw new IllegalStateException("Node '" + node + "' not found in it's parent list!!!!");
            }
            if (index - 1 >= 0) break;
            node = pnode;
        }
        node = children.get(index - 1);
        return this.getLastParagraphNodeDown(node);
    }

    private INode getFirstParagraphNodeDown(INode node) {
        IStyleSheet ssheet = node.getBook().getSystemStyleSheet();
        while (node.isContainer()) {
            List<INode> children = ((IContainerNode)node).getChildNodes();
            if (children.isEmpty()) {
                return node;
            }
            INode child = children.get(0);
            if (ssheet.getNodeDisplayType(child) == EDisplayType.INLINE) {
                return node;
            }
            node = child;
        }
        return node;
    }

    private INode getLastParagraphNodeDown(INode node) {
        IStyleSheet ssheet = node.getBook().getSystemStyleSheet();
        while (node.isContainer()) {
            List<INode> children = ((IContainerNode)node).getChildNodes();
            if (children.isEmpty()) {
                return node;
            }
            INode child = children.get(children.size() - 1);
            if (ssheet.getNodeDisplayType(child) == EDisplayType.INLINE) {
                return node;
            }
            node = child;
        }
        return node;
    }

    public void renderPage(boolean reformat) {
        INode savedNode = null;
        this.myPainter.clear();
        if (reformat) {
            if (this.myStartLine < this.myLines.size()) {
                savedNode = this.myLines.get(this.myStartLine).getParagraphNode();
                this.myStartLine = 0;
            }
            this.myLines.clear();
        }
        int lineNum = this.myStartLine;
        double previousDepth = 0.0;
        while (true) {
            IRenderingObject ro;
            Line line;
            if (lineNum >= this.myLines.size()) {
                INode node;
                if (this.myLines.size() == 0) {
                    node = savedNode == null ? this.getFirstParagraphNodeDown(this.myBook.getMainBody()) : savedNode;
                } else {
                    INode lastNode = this.myLines.get(this.myLines.size() - 1).getParagraphNode();
                    node = this.getNextParagraphNode(lastNode);
                }
                if (node == null) {
                    if (this.myStartLine >= this.myLines.size()) {
                        lineNum = this.myStartLine = this.myLines.size() - 1;
                        continue;
                    }
                    this.myNextPageLine = this.myStartLine;
                    return;
                }
                Line cur = new Line(true, node);
                cur.setLeftMargin(this.myBook.getSystemStyleSheet().getFirstLineMargin(node));
                cur.setRightMargin(this.myBook.getSystemStyleSheet().getRightMargin(node));
                cur = this.formatNode(this.myLines, cur, node);
                this.myLines.add(cur);
            }
            double vstrut = previousDepth + 1.0 + (line = this.myLines.get(lineNum)).getHeight() < 12.0 ? 12.0 : previousDepth + 1.0 + line.getHeight();
            this.myPainter.addVerticalStrut(vstrut);
            if (this.myPainter.getYCoordinate() + line.getHeight() > this.myPainter.getHeight()) {
                this.myNextPageLine = lineNum;
                return;
            }
            this.myPainter.addHorizontalStrut(line.getLeftMargin());
            Iterator<IRenderingObject> it = line.getObjects().iterator();
            while (it.hasNext() && (!(ro = it.next()).isGlue() || it.hasNext())) {
                ro.render();
            }
            this.myPainter.flushString();
            previousDepth = line.getDepth();
            ++lineNum;
        }
    }

    private void cleanStartLines() {
        int line = this.myStartLine;
        while (!this.myLines.get(line).isFirstLine()) {
            --line;
        }
        for (int i = 0; i < line; ++i) {
            this.myLines.remove(0);
        }
        this.myStartLine -= line;
        this.myNextPageLine -= line;
    }

    public void scrollPageUp() {
        double height = this.myPainter.getHeight();
        double nextHeight = 0.0;
        this.myNextPageLine = -1;
        if (this.myLines.isEmpty()) {
            return;
        }
        do {
            if (this.myStartLine == 0 && this.formatPreviousNode()) {
                return;
            }
            --this.myStartLine;
            Line line = this.myLines.get(this.myStartLine);
            double vstrut = nextHeight + 1.0 + line.getDepth() < 12.0 ? 12.0 : nextHeight + 1.0 + line.getDepth();
            this.myPainter.addVerticalStrut(vstrut);
            height -= vstrut;
            nextHeight = line.getHeight();
        } while (!(height < 0.0));
        ++this.myStartLine;
    }

    public void scrollPageDown() {
        if (this.myNextPageLine < 0) {
            return;
        }
        this.myStartLine = this.myNextPageLine;
        this.cleanStartLines();
    }

    public void scrollDown(int lines) {
        this.myStartLine += lines;
        this.myNextPageLine = -1;
        if (this.myStartLine >= this.myLines.size()) {
            return;
        }
        if (this.myLines.get(this.myStartLine).isFirstLine()) {
            this.cleanStartLines();
        }
    }

    public void scrollUp(int lines) {
        this.myStartLine -= lines;
        this.myNextPageLine = -1;
        if (this.myLines.isEmpty()) {
            return;
        }
        while (this.myStartLine < 0) {
            if (!this.formatPreviousNode()) continue;
            this.myStartLine = 0;
            break;
        }
    }

    private boolean formatPreviousNode() {
        INode node = this.getPreviousParagraphNode(this.myLines.get(0).getParagraphNode());
        if (node == null) {
            return true;
        }
        ArrayList<Line> curParagraph = new ArrayList<Line>();
        Line cur = new Line(true, node);
        cur.setLeftMargin(this.myBook.getSystemStyleSheet().getFirstLineMargin(node));
        cur.setRightMargin(this.myBook.getSystemStyleSheet().getRightMargin(node));
        cur = this.formatNode(curParagraph, cur, node);
        curParagraph.add(cur);
        this.myLines.addAll(0, curParagraph);
        this.myStartLine += curParagraph.size();
        return false;
    }
}

